`include "common.v"

/* Kolo predstavlja registar koji cuva osnovne flegove (O, S, Z, C)
   procesora. Oni se ucitavaju sa 4-bitnog ulaza in kad god je e_in
   aktivan i pamte se u registru. Vrednost sacuvanih flagova je uvek
   dostupan na izlazu out */
module psw(clk, in, out, e_in);
   input clk;
   input[3:0] in;
   input      e_in;
   output reg [3:0] out;

   initial
     out <= 0;
      
   always @(negedge clk)
     if(e_in)
       out <= in;

   always @(out)
     $display($time, ": psw (oszc) = %b", out);	  
   
endmodule // psw
