/* Model konacnog automata koji je isti kao onaj sa jednog od prethodnih
 dvocasa:
 
 STANJE x ULAZ --> NOVO_STANE x IZLAZ

0 0  --> 1 0
0 1  --> 2 0
1 0  --> 2 1
1 1  --> 3 0
2 0  --> 0 1
2 1  --> 3 1
3 0  --> 1 1
3 1  --> 1 0

 Verilog omogucava prirodno modelovanje ovakvih kola pomocu naredbi grananja
 na nivou modelovanja ponasanja (case i if naredbe). Prilikom sinteze, 
 odgovarajuci alat ce sam formirati i minimizovati odgovarajuca kombinatorna
 kola koja definisu novo stanje. Ovim je dizajner oslobodjen mukotrpnog 
 posla sastavljanja tablica ekcitacije i minimizacije logickih funkcija. 
 */

`define ST0 2'b00
`define ST1 2'b01
`define ST2 2'b10
`define ST3 2'b11

module automat(clk, x, y);
   input x, clk;
   
   output reg y;
   
   reg [1:0]  state;
   
   
   initial
     begin
	y <= 0;
	state <= `ST0;
     end   

   always @(posedge clk)
     begin
	case(state)
	  `ST0:
	    if(x == 0)
	      begin
		 y <= 0;
		 state <= `ST1;		 
	      end
	    else if(x == 1)
	      begin
		 y <= 0;
		 state <= `ST2;		 
	      end
	  `ST1:
	    if(x == 0)
	      begin
		 y <= 1;
		 state <= `ST2;		 
	      end
	    else if(x == 1)
	      begin
		 y <= 0;
		 state <= `ST3;		 
	      end
	  `ST2:
	    if(x == 0)
	      begin
		 y <= 1;
		 state <= `ST0;		 
	      end
	    else if(x == 1)
	      begin
		 y <= 1;
		 state <= `ST3;		 
	      end
	  `ST3:
	    if(x == 0)
	      begin
		 y <= 1;
		 state <= `ST1;		 
	      end
	    else if(x == 1)
	      begin
		 y <= 0;
		 state <= `ST1;		 
	      end	   
	endcase
     end
endmodule // automat
