`timescale 1ns/1ns
`include "adder.v"



module adder_test;

   reg [7:0] x, y;
   reg 	     pc;
   
   wire [7:0] s;
   wire       c;

   adder _adder(x, y, pc, s, c);
   
   
   initial
     begin
	// sa _adder.p pristupamo lokalnom podatku p u okviru instance _adder
	$monitor($time, ": x: %b, y: %b, s: %b, c: %b", 
		 x, y, s, c); 

	$dumpfile("adder.vcd");
	// pristupamo i podacima u svim direktnim podmodulima (_adder)
	$dumpvars(2, adder_test); 
	

	pc = 0;	
	x = 0;
	y = 0;

	#10 x = 8'b11111111;
	y = 8'b00000001;
	#10;	       	
     end
   

endmodule
